<?php

namespace Tuf\Metadata;

use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Collection;
use Symfony\Component\Validator\Constraints\Count;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Optional;
use Symfony\Component\Validator\Constraints\Required;
use Symfony\Component\Validator\Constraints\Type;

class TimestampMetadata extends FileInfoMetadataBase
{
    /**
     * {@inheritdoc}
     */
    public const TYPE = 'timestamp';

    /**
     * {@inheritdoc}
     */
    protected static function getSignedCollectionOptions(): array
    {
        $options = parent::getSignedCollectionOptions();
        $options['fields']['meta'] = new Required([
            new Type('array'),
            new Count(['min' => 1]),
            new All([
                new Collection([
                    'length' => new Optional([
                        new Type('integer'),
                        new GreaterThanOrEqual(1),
                    ]),
                ] + static::getHashesConstraints() + static::getVersionConstraints()),
            ]),
        ]);
        return $options;
    }
}
